/*

NewsCenter                     ▄ ▄ ▄
for Synchronet                 █████
Version 0.250413               ▐▄█▄▌ cf
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
by Craig Hendricks
codefenix@conchaos.synchro.net

ConstructiveChaos BBS:
  https://conchaos.synchro.net
 telnet://conchaos.synchro.net
    ssh://conchaos.synchro.net

*/

load("sbbsdefs.js");
load("rss-atom.js");
load("http.js");
load("frame.js");
require("html2asc.js", 'html2asc');
require("dd_lightbar_menu.js", "DDLightbarMenu");

const VERSION = "0.250413";
const EXEC_PATH = backslash(js.exec_dir);
const SCROLLER_PATH = "../xtrn/scroller/scroller.js";
const SCROLLER_CMD_FMT = '?%s "%s" "%s" %s';
const TEMP_PATH = EXEC_PATH + "temp" + bbs.node_num;
const WIDTH = console.screen_columns;
const HEIGHT = console.screen_rows;
const HDR_FILE = "newscenter" + (WIDTH >= 132 ? "_wide": "") + ".msg";
const DIVIDER = "\x01n\x01b" + (new Array(WIDTH).join(ascii(196))) + "\x01n";
const BW_TEXT = false;

function displayText(article_text, article_title) {
    const TEMP_NEWS_FILE = backslash(TEMP_PATH) + "temp-news.msg";
    var ftext = new File(TEMP_NEWS_FILE);
    ftext.open("w", false);
    ftext.write(article_text + "\x01n\x01b\x01h/===END===/" );
    ftext.close();
    if (file_exists(SCROLLER_PATH)) {
        bbs.exec( format(SCROLLER_CMD_FMT, SCROLLER_PATH, TEMP_NEWS_FILE, article_title, "top" ), 0, EXEC_PATH );
    } else {
        console.clear(false);
        console.printfile(TEMP_NEWS_FILE);        
        console.pause();                    
    }                               
    // file_remove(TEMP_NEWS_FILE);
}

function getFullArticle(article_url, article_title) {
    var success = false;
    const FROG_FIND_URL = "http://www.frogfind.com/read.php?a=";
    const TEMP_NEWS_HTML_FF = backslash(TEMP_PATH) + "temp-news-ff.html";
    const TEMP_NEWS_HTML_RAW = backslash(TEMP_PATH) + "temp-news-raw.html";
    print("\x01n\x01gGetting article from:\r\n\x01n\x01c" + article_url + "\x01n...\r\n");
    try {
        var resp = (new HTTPRequest()).Get(FROG_FIND_URL + article_url);
        var fhtml = new File(TEMP_NEWS_HTML_FF);
        fhtml.open("wb", false);
        fhtml.write(resp);
        fhtml.close();

        /***
          * TODO: Do this WITHOUT frogfind...
          */

        var resp2 = (new HTTPRequest()).Get(article_url);
        fhtml = new File(TEMP_NEWS_HTML_RAW);
        fhtml.open("wb", false);
        fhtml.write(resp2);
        fhtml.close();

        displayText("\x01q\x01l" +
            utf8_decode(html2asc(resp, BW_TEXT))  // convert the content to ascii
                .substr(50)                       // chop off the leading "back to Frogfind" text
                .replace(/\[(.|\n|\r)*?\]/g, "")  // strip out text between [] brackets, usually embedded urls, etc.
                .replace(/\r/g, "")
                .replace(/\n\n/g, "\x01n\n\n"),   // correct for colors that don't cancel
            article_title);
        success = true;
    } catch (err) {
        log(LOG_WARNING, "No response from: " + FROG_FIND_URL + article_url + "; err: " + err);
    }
    if (!success) {
        try {
            var resp_redo = (new HTTPRequest()).Get(article_url);
            fhtml_redo = new File(TEMP_NEWS_HTML_RAW);
            fhtml_redo.open("wb", false);
            fhtml_redo.write(resp_redo);
            fhtml_redo.close();

            displayText("\x01q\x01l" +
                utf8_decode(html2asc(resp_redo, BW_TEXT))  // convert the content to ascii
                    .replace(/\[(.|\n|\r)*?\]/g, "")  // strip out text between [] brackets, usually embedded urls, etc.
                    .replace(/\r/g, "")
                    .replace(/\n\n/g, "\x01n\n\n"),
                article_title);
            success = true;
        } catch (err) {
            print("\x01nFailed... \x01hPlease try again later.\x01n");
            log(LOG_WARNING, "No response from: " + article_url + "; err: " + err);
        }
    }
}

function showArticle(title, author, date, body, full_article_prompt, article_url) {
    console.clear();
    print("\x01n\x01bTitle:  \x01w\x01h" + lfexpand(word_wrap(title, WIDTH-10, WIDTH-10, true, true)).replace(/\r\n/g, "\r\n        ").trim());
    if (author) {
        printf("\x01n\x01bAuthor: \x01w\x01h%s\r\n", html2asc(author, BW_TEXT).trim());
    }
    print("\x01n\x01bDate:   \x01w\x01h" + (new Date(date)).toLocaleString());
    print(DIVIDER);
    print(lfexpand(word_wrap(utf8_decode(html2asc(body, BW_TEXT)), WIDTH-1, WIDTH-1, true, true)));
    if (full_article_prompt) {
        if (!console.noyes("Read full article text")) {
            getFullArticle(article_url, title);
        }
    } else {
        print("\x01n\x01b\x01h/===END===/");
        console.pause();
    }
}

function feedMenu(feedsource) {
    var msgFile = "";
    var selection = 0;
    var last_selected;
    var startY;
    var rss;
    printf("\x01L\x01nGetting feed for \x01h%s\x01n...", feedsource.name);
    try {
        rss = new Feed(feedsource.url).channels[0]; // It's normal to have at most one channel in a feed.
    } catch (f_err) {
        print("\x01n\r\n\r\nCouldn't get any data from " + feedsource.name + "\x01n, \x01hsorry!.\x01n");
        log(LOG_WARNING, f_err + " ... " + feedsource.name + " (url: " + feedsource.url + ")");
        return "BAD";
    }

    while (bbs.online && selection !== "Q") {
        selection = "";
        msgFile = backslash(EXEC_PATH + "gfx") + feedsource.icon + ".msg";
        console.clear();
        if (file_exists(msgFile)) {
            console.printfile(msgFile, P_NOABORT);
            startY = console.getxy().y;
        } else {
            log(LOG_WARNING, "Missing msg header file: " + msgFile);
            startY = 5;
        }
        console.gotoxy(30, 1);
        printf("\x01y\x01h%*s", WIDTH-30, rss.title.slice(0, WIDTH-31).trim());
        console.gotoxy(30, 2);
        printf("\x01w\x01h%*s", WIDTH-30, "updated " + system.timestr(new Date(rss.updated ? rss.updated : rss.items[0].date).getTime() / 1000));

        var frame = new Frame(31, 3, 49, 5, BG_BLACK);
        frame.open();
        frame.putmsg("\x01k\x01h" + lfexpand(word_wrap(utf8_decode(rss.description.trim()), 49, 49, true, true)).trim());
        frame.cycle();

        console.gotoxy(1, startY);
        print("\x01n\r\n" + format(WIDTH >= 132 ? "\x01c%2s\x01k\x01h)\x01n \x01w%-110s\x01n \x01b%-8s" : "\x01c%2s\x01k\x01h)\x01n \x01w%-65s\x01n \x01b%-8s", "#", "title", "added"));
        print(DIVIDER);

        console.gotoxy(1, console.screen_rows-1);
        console.center("\x01w\x01hQ\x01k\x01\h) \x01w\x01hQ\x01nuit to Feed Menu");
        var lbArticleMenu = new DDLightbarMenu(1, startY+3, WIDTH-1, HEIGHT - (startY+5));
        for (var i = 0; i < rss.items.length; i++) {
            lbArticleMenu.Add(format(WIDTH >= 132 ? "\x01c\x01h%2d\x01k\x01h)\x01n \x01w\x01h%-110.110s\x01n \x01b\x01h%-8.8s" : "\x01c\x01h%2d\x01k\x01h)\x01n \x01w\x01h%-65.65s\x01n \x01b\x01h%-8.8s",
                                     i+1,
                                     utf8_decode(rss.items[i].title).replace(/[^a-zA-Z0-9 -,'":!@#$%^&*()]/g, ""),
                                     system.datestr(new Date(rss.items[i].date).getTime() / 1000) ), i+1 );
        }
        lbArticleMenu.AddAdditionalQuitKeys("qQ");
        lbArticleMenu.colors.itemColor = "\x01k\x01h";
        lbArticleMenu.colors.selectedItemColor = "\x01w\x01h\x01" + "4";
        lbArticleMenu.scrollbarEnabled = true;
        lbArticleMenu.ampersandHotkeysInItems = false;
        if (last_selected) {
            lbArticleMenu.SetSelectedItemIdx(last_selected);
        }
        selection = lbArticleMenu.GetVal();

        if (!selection) { 
            selection = "Q";
        }
        if (!isNaN(selection)) {
            selection = parseInt(selection) - 1;
            last_selected = selection;
            if (feedsource.description_is_full_article) {
                displayText("\x01q\x01l" + utf8_decode(html2asc((rss.items[selection].body ?
                                     rss.items[selection].body :
                                     rss.items[selection].content), BW_TEXT)) 
                        .replace(/\r/g, "")
                    , utf8_decode(rss.items[selection].title));
            } else {
                showArticle(utf8_decode(rss.items[selection].title),
                            rss.items[selection].author,
                            rss.items[selection].date,
                            (rss.items[selection].body ?
                             rss.items[selection].body :
                             rss.items[selection].content),
                            feedsource.full_article_prompt,
                            rss.items[selection].link);
            }
        }
        frame.close();
    }
    return "OK";
}

function mainMenu() {
    var func_exit = false;
    var selection = "";
    var last_selected;
    var jSources = "";
    var fSources = new File(backslash(EXEC_PATH) + "newsfeeds.json");
    if (!file_isdir(TEMP_PATH)) {
        mkdir(TEMP_PATH);
    }
    if (fSources.open("r")) {
        jSources = JSON.parse(fSources.read());
        fSources.close();
        while (bbs.online && !js.terminated && !func_exit) {
            console.clear();
            console.printfile(backslash(EXEC_PATH + "gfx") + HDR_FILE, P_NOABORT);

            console.gotoxy(1, console.screen_rows-1);
            console.center("\x01w\x01hQ\x01k\x01\h) \x01w\x01hQ\x01nuit");

            var lbMenu = new DDLightbarMenu(18, 10, WIDTH - 34, HEIGHT - 12);
            for (var s = 0; s < Object.keys(jSources).length; s++) {
                lbMenu.Add(jSources[s].name + ( jSources[s].status ? ( (jSources[s].status==="BAD" ? " [!]" : "" )) : "" ), s+1 );
            }
            console.gotoxy(1, 9);
            console.center("\x01nUse \x01w\x01h" + ascii(24) + " \x01nand \x01w\x01h" + ascii(25) +" \x01nkeys to scroll, \x01w\x01hENTER \x01nselects");
            lbMenu.colors.itemColor = "\x01k\x01h";
            lbMenu.colors.selectedItemColor = "\x01w\x01h\x01" + "4";
            lbMenu.AddAdditionalQuitKeys("qQ");
            lbMenu.borderEnabled = true;
            lbMenu.scrollbarEnabled = true;
            if (last_selected) {
                lbMenu.SetSelectedItemIdx(last_selected);
            }
            selection = lbMenu.GetVal();

            if (!selection) { 
                func_exit = true;
            } else if (!isNaN(selection)) {
                selection = parseInt(selection) - 1;
                last_selected = selection;
                var result = feedMenu(jSources[selection]);
                jSources[selection].status = result;
                jSources[selection].last_used = system.timestr(new Date().getTime() / 1000);
                var fSourcesEdit = new File(EXEC_PATH + "newsfeeds.json");
                if (fSourcesEdit.open("w")) {
                    fSourcesEdit.write(JSON.stringify(jSources, undefined, 2));
                    fSourcesEdit.close();
                }
            }
        }
    }
}

mainMenu();
